/*
 * Decompiled with CFR 0.152.
 */
package nsusbloader.com.usb;

import java.io.File;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedHashMap;
import nsusbloader.ModelControllers.CancellableRunnable;
import nsusbloader.ModelControllers.ILogPrinter;
import nsusbloader.NSLDataTypes.EFileStatus;
import nsusbloader.NSLDataTypes.EMsgType;
import org.usb4java.DeviceHandle;

public abstract class TransferModule {
    protected static final byte IN_EP = -127;
    protected static final byte OUT_EP = 1;
    protected EFileStatus status = EFileStatus.UNKNOWN;
    protected LinkedHashMap<String, File> nspMap;
    protected ILogPrinter logPrinter;
    protected DeviceHandle handlerNS;
    protected CancellableRunnable task;

    protected TransferModule(DeviceHandle handler, LinkedHashMap<String, File> nspMap, CancellableRunnable task, ILogPrinter printer) {
        this.handlerNS = handler;
        this.nspMap = nspMap;
        this.task = task;
        this.logPrinter = printer;
        this.filterFiles();
    }

    void filterFiles() {
        this.nspMap.values().removeIf(f -> {
            if (f.isFile()) {
                return false;
            }
            File[] subFiles = f.listFiles((file, name) -> name.matches("[0-9]{2}"));
            if (subFiles == null || subFiles.length == 0) {
                this.print("TransferModule: Exclude folder: " + f.getName(), EMsgType.WARNING);
                return true;
            }
            Arrays.sort(subFiles, Comparator.comparingInt(file -> Integer.parseInt(file.getName())));
            for (int i = subFiles.length - 2; i > 0; --i) {
                if (subFiles[i].length() == subFiles[i - 1].length()) continue;
                this.print("TransferModule: Exclude split file: " + f.getName() + "\n      Chunk sizes of the split file are not the same, but has to be.", EMsgType.WARNING);
                return true;
            }
            long firstFileLength = subFiles[0].length();
            long lastFileLength = subFiles[subFiles.length - 1].length();
            if (lastFileLength > firstFileLength) {
                this.print("TransferModule: Exclude split file: " + f.getName() + "\n      Chunk sizes of the split file are not the same, but has to be.", EMsgType.WARNING);
                return true;
            }
            return false;
        });
    }

    public EFileStatus getStatus() {
        return this.status;
    }

    protected void print(String message, EMsgType type) {
        try {
            this.logPrinter.print(message, type);
        }
        catch (InterruptedException ie) {
            ie.printStackTrace();
        }
    }
}

