/*
 * Decompiled with CFR 0.152.
 */
package libKonogonka.fs.NSO;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.Arrays;
import libKonogonka.aesctr.InFileStreamProducer;
import libKonogonka.fs.NSO.NSO0Header;
import libKonogonka.fs.NSO.NSO0Raw;
import libKonogonka.fs.NSO.SegmentHeader;
import net.jpountz.lz4.LZ4Factory;
import net.jpountz.lz4.LZ4SafeDecompressor;

class NSO0Unpacker {
    private static final String DECOMPRESSED_FILE_NAME = "main_decompressed";
    private final MessageDigest digest = MessageDigest.getInstance("SHA-256");
    private final NSO0Header nso0Header;
    private final InFileStreamProducer producer;
    private byte[] _textDecompressedSection;
    private byte[] _rodataDecompressedSection;
    private byte[] _dataDecompressedSection;
    private byte[] header;
    private int textFileOffsetNew;
    private int rodataFileOffsetNew;
    private int dataFileOffsetNew;

    private NSO0Unpacker(NSO0Header nso0Header, InFileStreamProducer producer) throws Exception {
        this.nso0Header = nso0Header;
        this.producer = producer;
        this.decompressSections();
        this.validateHashes();
        this.makeHeader();
    }

    static NSO0Raw getNSO0Raw(NSO0Header nso0Header, InFileStreamProducer producer) throws Exception {
        NSO0Unpacker instance = new NSO0Unpacker(nso0Header, producer);
        return new NSO0Raw(instance.header, instance._textDecompressedSection, instance._rodataDecompressedSection, instance._dataDecompressedSection);
    }

    static void unpack(NSO0Header nso0Header, InFileStreamProducer producer, String saveToLocation) throws Exception {
        if (!(nso0Header.isTextCompressFlag() || nso0Header.isRoCompressFlag() || nso0Header.isDataCompressFlag())) {
            throw new Exception("This file is not compressed");
        }
        NSO0Unpacker instance = new NSO0Unpacker(nso0Header, producer);
        instance.writeFile(saveToLocation);
    }

    private void decompressSections() throws Exception {
        this.decompressTextSection();
        this.decompressRodataSection();
        this.decompressDataSection();
    }

    private void decompressTextSection() throws Exception {
        this._textDecompressedSection = this.nso0Header.isTextCompressFlag() ? this.decompressSection(this.nso0Header.getTextSegmentHeader(), this.nso0Header.getTextCompressedSize()) : this.duplicateSection(this.nso0Header.getTextSegmentHeader());
    }

    private void decompressRodataSection() throws Exception {
        this._rodataDecompressedSection = this.nso0Header.isRoCompressFlag() ? this.decompressSection(this.nso0Header.getRodataSegmentHeader(), this.nso0Header.getRodataCompressedSize()) : this.duplicateSection(this.nso0Header.getRodataSegmentHeader());
    }

    private void decompressDataSection() throws Exception {
        this._dataDecompressedSection = this.nso0Header.isDataCompressFlag() ? this.decompressSection(this.nso0Header.getDataSegmentHeader(), this.nso0Header.getDataCompressedSize()) : this.duplicateSection(this.nso0Header.getDataSegmentHeader());
    }

    private byte[] decompressSection(SegmentHeader segmentHeader, int compressedSectionSize) throws Exception {
        try (BufferedInputStream stream = this.producer.produce();){
            byte[] restored;
            int sectionDecompressedSize = segmentHeader.getSize();
            byte[] compressed = new byte[compressedSectionSize];
            if ((long)segmentHeader.getSegmentOffset() != stream.skip(segmentHeader.getSegmentOffset())) {
                throw new Exception("Failed to skip " + segmentHeader.getSegmentOffset() + " bytes till section");
            }
            if (compressedSectionSize != stream.read(compressed)) {
                throw new Exception("Failed to read entire section");
            }
            LZ4Factory factory = LZ4Factory.fastestInstance();
            LZ4SafeDecompressor decompressor = factory.safeDecompressor();
            int decompressedLength = decompressor.decompress(compressed, 0, compressedSectionSize, restored = new byte[sectionDecompressedSize], 0);
            if (decompressedLength != sectionDecompressedSize) {
                throw new Exception("Decompression failure. Expected vs. actual decompressed sizes mismatch: " + decompressedLength + " / " + sectionDecompressedSize);
            }
            byte[] byArray = restored;
            return byArray;
        }
    }

    private byte[] duplicateSection(SegmentHeader segmentHeader) throws Exception {
        try (BufferedInputStream stream = this.producer.produce();){
            int size = segmentHeader.getSize();
            byte[] sectionContent = new byte[size];
            if ((long)segmentHeader.getSegmentOffset() != stream.skip(segmentHeader.getSegmentOffset())) {
                throw new Exception("Failed to skip " + segmentHeader.getSegmentOffset() + " bytes till section");
            }
            if (size != stream.read(sectionContent)) {
                throw new Exception("Failed to read entire section");
            }
            byte[] byArray = sectionContent;
            return byArray;
        }
    }

    private void validateHashes() throws Exception {
        if (!Arrays.equals(this.nso0Header.getTextHash(), this.digest.digest(this._textDecompressedSection))) {
            throw new Exception(".text hash mismatch for .text section");
        }
        if (!Arrays.equals(this.nso0Header.getRodataHash(), this.digest.digest(this._rodataDecompressedSection))) {
            throw new Exception(".rodata hash mismatch for .text section");
        }
        if (!Arrays.equals(this.nso0Header.getDataHash(), this.digest.digest(this._dataDecompressedSection))) {
            throw new Exception(".data hash mismatch for .text section");
        }
    }

    private void makeHeader() throws Exception {
        try (BufferedInputStream stream = this.producer.produce();){
            byte[] headerBytes = new byte[256];
            if (256 != stream.read(headerBytes)) {
                throw new Exception("Unable to read initial 0x100 bytes needed for export.");
            }
            this.textFileOffsetNew = this.nso0Header.getTextSegmentHeader().getMemoryOffset() + 256;
            this.rodataFileOffsetNew = this.nso0Header.getRodataSegmentHeader().getMemoryOffset() + 256;
            this.dataFileOffsetNew = this.nso0Header.getDataSegmentHeader().getMemoryOffset() + 256;
            ByteBuffer resultingHeader = ByteBuffer.allocate(256).order(ByteOrder.LITTLE_ENDIAN);
            resultingHeader.put("NSO0".getBytes(StandardCharsets.US_ASCII)).putInt(this.nso0Header.getVersion()).put(this.nso0Header.getUpperReserved()).putInt(this.nso0Header.getFlags() & 0x38).putInt(this.textFileOffsetNew).putInt(this.nso0Header.getTextSegmentHeader().getMemoryOffset()).putInt(this.nso0Header.getTextSegmentHeader().getSize()).putInt(256).putInt(this.rodataFileOffsetNew).putInt(this.nso0Header.getRodataSegmentHeader().getMemoryOffset()).putInt(this.nso0Header.getRodataSegmentHeader().getSize()).putInt(0).putInt(this.dataFileOffsetNew).putInt(this.nso0Header.getDataSegmentHeader().getMemoryOffset()).putInt(this.nso0Header.getDataSegmentHeader().getSize()).putInt(this.nso0Header.getBssSize()).put(this.nso0Header.getModuleId()).putInt(this.nso0Header.getTextSegmentHeader().getSize()).putInt(this.nso0Header.getRodataSegmentHeader().getSize()).putInt(this.nso0Header.getDataSegmentHeader().getSize()).put(this.nso0Header.getBottomReserved()).putInt(this.nso0Header.get_api_infoRelative().getOffset()).putInt(this.nso0Header.get_api_infoRelative().getSize()).putInt(this.nso0Header.get_dynstrRelative().getOffset()).putInt(this.nso0Header.get_dynstrRelative().getSize()).putInt(this.nso0Header.get_dynsymRelative().getOffset()).putInt(this.nso0Header.get_dynsymRelative().getSize()).put(this.nso0Header.getTextHash()).put(this.nso0Header.getRodataHash()).put(this.nso0Header.getDataHash());
            this.header = resultingHeader.array();
        }
    }

    private void writeFile(String saveToLocation) throws Exception {
        File location = new File(saveToLocation);
        location.mkdirs();
        try (RandomAccessFile raf = new RandomAccessFile(saveToLocation + File.separator + DECOMPRESSED_FILE_NAME, "rw");){
            raf.write(this.header);
            raf.seek(this.textFileOffsetNew);
            raf.write(this._textDecompressedSection);
            raf.seek(this.rodataFileOffsetNew);
            raf.write(this._rodataDecompressedSection);
            raf.seek(this.dataFileOffsetNew);
            raf.write(this._dataDecompressedSection);
        }
    }
}

